<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>
<?php

if (is_single()) {
    the_title('<h1 class="news__title">', '</h1>');
} elseif (is_front_page() && is_home()) {
    the_title('<h3 class="entry-title">А здесь ты попался на главной<a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>');
}
?>

    <div class="news__article">
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <div class="news__content">

                <?php if ('' !== get_the_post_thumbnail() && !is_single()) : ?>

                    <a href="<?php the_permalink(); ?>">
                        <?php the_post_thumbnail('twentyseventeen-featured-image'); ?>
                    </a>

                <?php endif; ?>

                <?php if ('' !== get_the_post_thumbnail() && is_single()) {
                    the_post_thumbnail('twentyseventeen-featured-image');
                }
                ?>

                <?php

                if (!is_single()) {
                    the_title('<h2 class="news__box-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
                }
                ?>

                <?php if ('post' === get_post_type()) {
                    twentyseventeen_posted_on();
                };
                ?>

                <div class="news__text">
                    <?php the_excerpt(); ?>
                </div>
                <div class="news__more-holder">
                    <a href="<?php echo esc_url(get_permalink()) ?>" class="news__more button button--white">
                        <span class="button__text">Подробнее</span>
                    </a>
                </div>
            </div>

        </article><!-- #post-## -->
    </div>
