<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

$service_price            = get_field('service_price');
$service_symptoms         = get_field('service_symptoms');
$service_left_field       = get_field('service_left_field');
$service_right_field      = get_field('service_right_field');
$service_specialist       = get_field('service_specialist');
$service_specialist_name  = $service_specialist->post_title;
$service_specialist_job   = $service_specialist->post_content;
$service_specialist_id    = $service_specialist->id;
$service_specialist_image = get_the_post_thumbnail($service_specialist);
$specialists_array        = get_fields($service_specialist);
$specialist_experience    = $specialists_array['specialist_experience'];
$specialist_auditory      = $specialists_array['specialist_auditory'];

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <?php the_title('<h1 class="service__title">', '</h1>'); ?>

    <div class="service__info info-service">
        <div class="info-service__image-holder">
            <?php if ('' !== get_the_post_thumbnail() && is_single()) {
                the_post_thumbnail('');
            }
            ?>
        </div>
        <div class="info-service__box">
            <div class="info-service__text">
                <?php the_content(); ?>
            </div>
        </div>
    </div>
    <?php if ($service_symptoms || $service_specialist) { ?>

        <div class="service__card card">
            <?php if ($service_symptoms) { ?>
                <div class="card__info">
                    <h3 class="card__title">Необходимо обращаться при:</h3>
                    <?php echo $service_symptoms; ?>
                </div>
            <?php } ?>
            <?php if ($service_specialist) { ?>
                <div class="card__specialist">
                    <div class="specialists__box">
                        <div class="specialists__image-holder">
                            <div class="specialists__image-box">
                                <?php echo $service_specialist_image; ?>
                            </div>
                        </div>
                        <div class="specialists__inner">
                            <h3 class="specialists__name"><?php echo $service_specialist_name; ?></h3>
                            <h4 class="specialists__position"><?php echo $service_specialist_job; ?></h4>
                            <?php if ('' !== $specialist_experience) { ?>
                                <strong class="specialists__description"><?php echo $specialist_experience; ?></strong>
                            <?php } ?>
                        </div>
                        <?php if ('' !== $specialist_auditory) { ?>
                            <div class="specialists__acceptence">
                    <span class="specialists__acceptence-text">
                        <?php echo $specialist_auditory; ?>
                    </span>
                            </div>
                        <?php } ?>
                        <div class="specialists__info">
                            <?php if ('' !== $service_price) { ?>
                                <strong class="specialists__price">Стоимость: <span><?php echo $service_price; ?></span>
                                    грн.</strong>
                            <?php } ?>
                            <a class="specialists__more button js-scroll-link" href="#slider-footer">
                                <span class="button__text">Записаться</span>
                            </a>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    <?php } ?>
    <?php if ($service_left_field || $service_right_field) { ?>
        <div class="service__descr">
            <div class="service__descr-box">
                <?php echo $service_left_field; ?>
            </div>
            <div class="service__descr-box">
                <?php echo $service_right_field; ?>
            </div>
        </div>
    <?php } ?>

</article><!-- #post-## -->