<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>
<?php
    the_title('<h1 class="news__title">', '</h1>');
?>
<div class="news__holder">
    <div class="news__article">
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <div class="news__content">

                <?php if ('' !== get_the_post_thumbnail() && is_single()) {
                    the_post_thumbnail('twentyseventeen-featured-image');
                }
                ?>

                <?php if ('post' === get_post_type()) {
                    twentyseventeen_posted_on();
                };
                ?>

                <div class="news__text">
                    <?php
                    /* translators: %s: Name of current post */
                    the_content(
                        sprintf(
                            __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'twentyseventeen'),
                            get_the_title()
                        )
                    );
                    ?>
                </div>

            </div>

        </article><!-- #post-## -->
    </div>
</div>