<?php
/**
 * Template part for displaying posts with excerpts
 *
 * Used in Search Results and for Recent Posts in Front Page panels.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>
<div class="news__article">
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        <?php
        if (is_front_page() && !is_home()) {

            // The excerpt is being displayed within a front page section, so it's a lower hierarchy than h2.
            the_title(sprintf('<h3 class="news__box-title"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
        } else {
            the_title(sprintf('<h2 class="news__box-title"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h2>');
        }
        ?>

        <div class="news__text">
            <?php the_excerpt(); ?>
        </div><!-- .entry-summary -->

    </article><!-- #post-## -->
</div>