<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

// vars
$service_price = get_field('service_price');
?>

<div class="services__box" <?php post_class(); ?> id="post-<?php the_ID(); ?>">
    <h2 class="services__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

    <?php if ('' !== get_the_post_thumbnail()) { ?>
        <a href="<?php the_permalink(); ?>">
            <?php the_post_thumbnail(); ?>
        </a>
    <?php } ?>

    <div class="services__info">
        <?php if ('' !== $service_price) { ?>
        <strong class="services__price">Стоимость: <span><?php echo $service_price; ?></span> грн.</strong>
        <?php } ?>
        <a href="<?php the_permalink(); ?>" class="services__more button">
            <span class="button__text">Подробнее</span>
        </a>
    </div>

</div><!-- #post-## -->
