<?php
/**
 * Template part for displaying page content in page-contacts.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<!-- contacts -->
<div class="contacts">
    <header class="entry-header">
        <?php the_title( '<h1 class="main__title">', '</h1>' ); ?>
    </header><!-- .entry-header -->
    <div class="contacts__goal goal">
        <img class="goal__image" src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-contacts.jpg" alt="Наша цель - Полное выздоровление пациента">
        <div class="goal__box">
            <span class="goal__text">Наша цель</span>
            <strong class="goal__descr">Полное выздоровление пациента</strong>
        </div>
    </div>
    <div class="contacts__info">
        <div class="clearfix">
            <div class="contacts__box">
                <div class="contacts__brand">
                    <strong class="logo">
                        <a class="logo__link" href="/">
                            <svg class="logo__icon" width="81" height="37">
                                <use xlink:href="#icon-logo"></use>
                            </svg>
                            <span class="visually-hidden">Refit</span>
                        </a>
                    </strong>
                    <strong class="contacts__slogan">Центр реабилитация <span>позвоночника и суставов</span></strong>
                </div>
                <ul class="contacts__work">
                    <li class="contacts__schedule-item">
                        <span>ГРАФИК РАБОТЫ:</span>
                        <span>Понедельник - Пятница: 8:00 - 21:00, Суббота: 8:00 - 18:00</span>
                    </li>
                </ul>
            </div>
            <ul class="contacts__schedule">
                <li class="contacts__schedule-item">
                    <span>ТЕЛЕФОН:</span>
                    <a class="contacts__schedule-link" href="tel:+380577660651">+38 (057) 766-06-51</a>
                </li>
                <li class="contacts__schedule-item">
                    <span>E-MAIL:</span>
                    <a class="contacts__schedule-link" href="mailto:info@fortis.kharkov.ua">info@fortis.kharkov.ua</a>
                </li>
            </ul>
        </div>
        <div class="entry-content">
            <?php
            the_content();
            ?>
        </div><!-- .entry-content -->
    </div>
</div>
<!--/contacts-->
</article><!-- #post-## -->

