<?php
/**
 * The template for displaying taxonomy-topics pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

// get the current taxonomy term
$term = get_queried_object();

// vars
$taxonomy_image       = get_field('taxonomy_image', $term);
$taxonomy_title       = $term->name;
$taxonomy_description = $term->description;

get_header(); ?>
    <!-- categories -->
    <div class="category">
        <div class="category__info info-category">
            <?php if ($taxonomy_image) { ?>
                <div class="info-category__image-holder">

                    <img class="info-category__image"
                         src="<?php echo $taxonomy_image['url']; ?>"
                         alt="Services Image">

                </div>
            <?php } ?>
            <div class="info-category__box">
                <?php if (have_posts()) : ?>
                    <h1 class="info-category__title"><?php echo $taxonomy_title; ?></h1>
                <?php endif; ?>

                <div class="info-category__text">
                    <p><?php echo $taxonomy_description; ?></p>
                </div>
            </div>
        </div>
        <div class="category__services services">

            <?php
            if (have_posts()) :
                ?>
                <?php
                /* Start the Loop */
                while (have_posts()) :
                    the_post();

                    /*
                     * Include the Post-Format-specific template for the content.
                     * If you want to override this in a child theme, then include a file
                     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                     */

                    get_template_part('template-parts/post/content', 'category-services');

                endwhile;

            else :

                get_template_part('template-parts/post/content', 'none');

            endif;
            ?>

        </div>
    </div>
    <!--/categories-->

<?php
get_footer();
