<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

/*$home_taxonomies_args = array(
    'taxonomy'   => 'services_categories',
    'hide_empty' => false,
    'parent'     => '11',
    'number'     => '3',
);

$home_taxonomies = get_terms($home_taxonomies_args);


$doctors_array = get_posts(
    array(
        'posts_per_page' => -1,
        'post_type'      => 'doctors',
    )
);*/

get_header(); ?>

    <div class="banner">
        <div id="splide" class="splide" style="padding-top: 0">
            <div class="splide__track">
                <ul class="splide__list">
                    <li class="splide__slide" data-splide-html-video="<?php echo get_template_directory_uri(); ?>/assets/splide_assets/MVI_8108_c.mp4">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/splide_assets/video_bg.png" alt="Slider Image">
                    </li>
                    <li class="splide__slide" style="width: 150px" data-splide-youtube="https://www.youtube.com/embed/M2sVHATgUVM">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/splide_assets/video_bg.png" alt="Slider Image">
                        <!--<img src="./Refit — Центр реабилитация позвоночника и суставов_files/img-banner-therapy.jpg">-->
                    </li>
                </ul>
            </div>
        </div>
<!--                <a class="js-show-video fancybox.iframe" href="https://www.youtube.com/embed/M2sVHATgUVM?autoplay=1">
                    <img class="img-responsive" src="<?php /*echo get_template_directory_uri(); */?>/assets/images/content/img-banner-therapy.jpg" alt="Здоровье легким! Физическая терапия для восстановления функции легких после пневмонии и бронхита">
                </a>-->

    </div>
    <!-- main -->
    <main class="main">
        <!-- section consultation -->
        <section class="section section--right section--consultation" id="section--consultation">
            <div class="consult">
                <h2 class="section__title">Консультации врачей <br> и диагностика</h2>
                <h3 class="section__subtitle">«В здоровом теле здоровый дух!»</h3>
                <div class="section__inner">
                    <div class="section__info">
                        <div class="text-box">
                            <p>Для успешной реабилитации в зале кинезиотерапии необходимо пройти диагностику состояния опорно-двигательного аппарата и организма в целом. В нашем центре работают вертебролог, невропатолог, эндокринолог, диетолог - квалифицированные специалисты, которые установят причину заболевания клиента и дадут рекомендации по лечению и дальнейшей реабилитации.</p>
                            <p>Также одновременно с серией занятий в зале реабилитации клиенты могут пройти курс лечебного массажа по методу Климентьевой Л.З., который во многом способствует быстрейшему восстановлению. </p>
                            <div class="more__holder js-more__holder">
                                <button class="more__button js-more__button" type="button">Подробнее</button>
                            </div>
                            <div class="more__box js-more__box hidden">
                                <span>Консультация специалистов-медиков необходима при:</span>
                                <ul>
                                    <li>- заболеваниях опорно-двигательного аппарата;</li>
                                    <li>- болях различной локализации;</li>
                                    <li>- головных болях, головокружении, шуме в ушах;</li>
                                    <li>- эндокринных патологиях; </li>
                                    <li>- коррекции массы тела;</li>
                                    <li>- родовых травмах у детей;</li>
                                    <li>- поясничных болях у беременных.</li>
                                </ul>
                                <p>Для более детальной консультации необходимо иметь при себе существующие исследования (рентген, МРТ, КТ).</p>
                            </div>
                        </div>
                        <div class="service">
                            <div class="service__box">
                                <span class="service__text">Стоимость услуги</span>
                                <div class="service__oldprice">
                                    500 грн
                                </div>
                                <div class="service__price">
                                    <strong>300</strong> грн
                                </div>
                            </div>
                            <button class="button js-button" type="button">
                                <span>Записаться</span>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/telegram.svg" alt="">
                            </button>
                        </div>
                    </div>
                    <div class="section__image">
                        <div class="image-holder">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-consult.jpg"
                                 alt="Консультации врачей и диагностика">
                            <span class="caption">Прием ведет Климентьева Л.З. - автор методики «Восстановительная физическая терапия»</span>
                        </div>
                        <ul class="image-list">
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-consult-big4.jpg"
                                       rel="section-consult">
                                        <span class="visually-hidden">Консультации врачей и диагностика</span>
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-consult-big2.jpg"
                                       rel="section-consult">
                                        <span class="visually-hidden">Консультации врачей и диагностика</span>
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-consult-big3.jpg"
                                       rel="section-consult">
                                        <span class="visually-hidden">Консультации врачей и диагностика</span>
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <!--/section consultation -->
        <!-- section physiotherapy -->
        <section class="section section--physiotherapy" id="section--physiotherapy">
            <div class="physio">
                <h2 class="section__title">Лечебная гимнастика <br> и физическая реабилитация</h2>
                <h3 class="section__subtitle">«В здоровом теле здоровый дух!»</h3>
                <div class="section__inner">
                    <div class="section__info">
                        <div class="text-box">
                            <p>Подбор комплекса упражнений и весовой нагрузки для каждого пациента осуществляется с
                                учетом его диагноза и уровня физической подготовки. На занятии прорабатываются все группы
                                мышц. Тренировки  проходят на декомпрессионных тренажерах, которые позволяют работать с
                                отягощением, но без компрессионной нагрузки на позвоночник и суставы.</p>
                            <div class="more__holder js-more__holder">
                                <button class="more__button js-more__button" type="button">Подробнее</button>
                            </div>
                            <div class="more__box js-more__box hidden">
                                <span>Занятия в реабилитационном зале назначаются при:</span>
                                <ul>
                                    <li>- восстановлении после травм (переломы, вывихи, разрывы/надрывы связок);</li>
                                    <li>- до- и послеоперационный период при замене суставов;</li>
                                    <li>- остеохондрозе;</li>
                                    <li>- остеопорозе;</li>
                                    <li>- нарушениях осанки;</li>
                                    <li>- коксартрозе, артрите, артрозе;</li>
                                    <li>- бурсите;</li>
                                    <li>- плечелопаточном  переартрите.</li>
                                </ul>
                                <p>Физические упражнения позволяют устранить болевой синдром, уменьшить рецидивы
                                    заболеваний путем укрепления мышечного корсета.</p>
                                <p>А также увеличить мобильность суставов, улучшить кровообращение и лимфоток,
                                    нормализовать AD.</p>
                            </div>
                        </div>
                        <div class="service">
                            <div class="service__box">
                                <span class="service__text">Стоимость услуги</span>
                                <div class="service__price">
                                    <strong>300</strong> грн
                                </div>
                            </div>
                            <button class="button js-button" type="button">
                                <span>Записаться</span>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/telegram.svg" alt="">
                            </button>
                        </div>
                    </div>
                    <div class="section__image">
                        <div class="image-holder">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-physio.jpg"
                                 alt="Лечебная гимнастика и физическая реабилитация">
                        </div>
                        <ul class="image-list">
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-physio-big4.jpg"
                                       rel="section-physio">
                                        <span class="visually-hidden">Лечебная гимнастика и физическая реабилитация</span>
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-physio-big5.jpg"
                                       rel="section-physio">
                                        <span class="visually-hidden">Лечебная гимнастика и физическая реабилитация</span>
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-physio-big3.jpg"
                                       rel="section-physio">
                                        <span class="visually-hidden">Лечебная гимнастика и физическая реабилитация</span>
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <!--/section physiotherapy -->
        <!-- section kinesitherapy -->
        <section class="section section--right section--kinesitherapy" id="section--kinesitherapy">
            <div class="kinesi">
                <h2 class="section__title">Декомпрессионная <br> кинезотерапия</h2>
                <h3 class="section__subtitle">«В здоровом теле здоровый дух!»</h3>
                <div class="section__inner">
                    <div class="section__info">
                        <div class="text-box">
                            <p>Преимуществом тренировок на декомпрессионных тренажерах является работа с отягощением без
                                компрессионного давления на позвоночник. Методика тренировок позволяет укрепить глубокие
                                мышцы спины и снять компрессионную нагрузку с межпозвонковых дисков и суставов.</p>
                            <div class="more__holder js-more__holder">
                                <button class="more__button js-more__button" type="button">Подробнее</button>
                            </div>
                            <div class="more__box js-more__box hidden">
                                <span>Специфика упражнений позволяет избавиться от болевого синдрома при:</span>
                                <ul>
                                    <li>- грыжах межпозвонковых дисков;</li>
                                    <li>- протрузиях;</li>
                                    <li>- межреберной невралгии;</li>
                                    <li>- ущемлении седалищного нерва.</li>
                                </ul>
                            </div>
                        </div>
                        <div class="service">
                            <div class="service__box">
                                <span class="service__text">Стоимость услуги</span>
                                <div class="service__price">
                                    <strong>300</strong> грн
                                </div>
                            </div>
                            <button class="button js-button" type="button">
                                <span>Записаться</span>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/telegram.svg" alt="">
                            </button>
                        </div>
                    </div>
                    <div class="section__image">
                        <div class="image-holder">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-kinesi.jpg" alt="Декомпрессионная кинезотерапия">
                        </div>
                        <ul class="image-list">
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-kinesi-big1.jpg"
                                       rel="section-kinesi">
                                        <span class="visually-hidden">Декомпрессионная кинезотерапия</span>
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-kinesi-big4.jpg"
                                       rel="section-kinesi">
                                        <span class="visually-hidden">Декомпрессионная кинезотерапия</span>
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-kinesi-big5.jpg"
                                       rel="section-kinesi">
                                        <span class="visually-hidden">Декомпрессионная кинезотерапия</span>
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <!--/section kinesitherapy -->
        <!-- section kids -->
        <section class="section section--kids" id="section--kids">
            <div class="kids">
                <h2 class="section__title">Детские программы</h2>
                <h3 class="section__subtitle">«В здоровом теле здоровый дух!»</h3>
                <div class="section__inner">
                    <div class="section__info">
                        <div class="text-box">
                            <p>Учитывая возрастные особенности детей, занятия очень
                                эффективны при лечении и профилактике нарушений
                                осанки: сколиозе, кифозе, лордозе.</p>
                            <p>Основной задачей является укрепление мышечного
                                корсета, устранение мышечного дисбаланса и
                                миофасциального синдрома.
                                Допуск детей в зал с 10 лет. </p>
                            <div class="more__holder js-more__holder">
                                <button class="more__button js-more__button" type="button">Подробнее</button>
                            </div>
                            <div class="more__box js-more__box hidden">
                                <p>Для пробного занятия необходимо иметь при себе:</p>
                                <ul>
                                    <li>- существующие исследования (рентген, МРТ, КТ)</li>
                                    <li>- спортивную форму и сменную спортивную обувь.</li>
                                </ul>
                                <p>На основе пробного занятия реабилитолог дает рекомендации по поводу частоты посещения
                                    занятий и программы реабилитации.</p>
                            </div>
                        </div>
                        <div class="service">
                            <div class="service__box">
                                <span class="service__text">Стоимость услуги</span>
                                <div class="service__price">
                                    <strong>300</strong> грн
                                </div>
                            </div>
                            <button class="button js-button" type="button">
                                <span>Записаться</span>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/telegram.svg" alt="">
                            </button>
                        </div>
                    </div>
                    <div class="section__image">
                        <div class="image-holder">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-kids.jpg" alt="">
                        </div>
                        <ul class="image-list">
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-kids-big1.jpg"
                                       rel="section-kids">
                                        <span class="visually-hidden">Детские программы</span>
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-kids-big2.jpg"
                                       rel="section-kids">
                                        <span class="visually-hidden">Детские программы</span>
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-kids-big3.jpg"
                                       rel="section-kids">
                                        <span class="visually-hidden">Детские программы</span>
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <!--/section kids -->
        <? /*
        <!-- section trial -->
        <section class="section section--right section--trial" id="section--trial">
            <div class="trial">
                <h2 class="section__title">Пробное занятие</h2>
                <h3 class="section__subtitle">«Быть здоровым, жить <br> активно – это стильно, позитивно!»</h3>
                <div class="section__inner">
                    <div class="section__info">
                        <div class="text-box">
                            <p>Включает в себя консультацию врача и занятие в реабилитационном зале.</p>
                            <p>Цель пробной тренировки - подобрать индивидуальную программу оздоровления с учетом
                                диагноза пациента, основываясь на реакции организма на нагрузку.</p>
                            <p>Во время первой тренировки реабилитолог подбирает комплекс упражнений, а также нагрузку
                                для достижения наилучшего результата в процессе оздоровления.</p>
                            <p>На пробном занятии необходимо иметь при себе:</p>
                            <div class="more__holder js-more__holder">
                                <button class="more__button js-more__button" type="button">Подробнее</button>
                            </div>
                            <div class="more__box js-more__box hidden">
                                <ul>
                                    <li>существующие исследования (рентген, МРТ, КТ)</li>
                                    <li>спортивную форму и сменную спортивную обувь.</li>
                                </ul>
                                <p>На основе пробного занятия реабилитолог  дает рекомендации по поводу частоты посещения
                                    занятий и курса реабилитации.</p>
                            </div>
                        </div>
                        <div class="service">
                            <div class="service__box">
                                <span class="service__text">Стоимость услуги</span>
                                <div class="service__price">
                                    <strong>250</strong> грн
                                </div>
                            </div>
                            <button class="button js-button" type="button">
                                <span>Записаться</span>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/telegram.svg" alt="">
                            </button>
                        </div>
                    </div>
                    <div class="section__image">
                        <div class="image-holder">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-trial.jpg" alt="">
                        </div>
                        <ul class="image-list">
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-trial-big1.jpg"
                                       rel="section-trial">
                                        <img class="image-list__image" src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-trial-small1.jpg"
                                             alt="">
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-trial-big2.jpg"
                                       rel="section-trial">
                                        <img class="image-list__image" src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-trial-small2.jpg"
                                             alt="">
                                    </a>
                                </div>
                            </li>
                            <li class="image-list__item">
                                <div class="image-list__holder">
                                    <a class="fancybox" href="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-trial-big3.jpg"
                                       rel="section-trial">
                                        <img class="image-list__image" src="<?php echo get_template_directory_uri(); ?>/assets/images/content/img-trial-small3.jpg"
                                             alt="">
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <!--/section trial -->
        */ ?>
        <!-- section map -->
        <section class="section section--map" id="section--map">
            <div class="map">
                <div class="map__address">
                    <div class="address">
                        <h3 class="address__title">Наши адреса</h3>
                        <div class="address__text">
                            <p>Удобное месторасположение наших залов в разных
                                уголках города, поможет Вам всегда оставаться
                                в хорошей форме и поддерживать Ваше здоровье.</p>
                        </div>
                    </div>
                    <div class="switcher">
                        <div class="switcher__inner">
                            <div class="address__tabs tabs-address">
                                <button
                                    class="tabs-address__button js-tabs-address__button--first is-active js-tabs-address__button">
                                    <strong>050-323-08-08</strong>
                                    <span>Пр. Науки, 9 Д</span>
                                    <em>Показать на карте</em>
                                </button>
                                <button
                                    class="tabs-address__button js-tabs-address__button--second js-tabs-address__button">
                                    <strong>050-343-60-40</strong>
                                    <span>Пр. Тракторостроителей, 1 Б</span>
                                    <em>Показать на карте</em>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="address__map-holder">
                    <div class="address__map-box js-address__map-box--first js-address__map-box">
                        <div class="address__map-info">
                            <h4 class="address__map-title">Пр. Науки, 9 Д</h4>
                            <ul class="address__map-list">
                                <li class="address__map-item"><a href="tel:+380503230808">050/097-323-08-08</a></li>
                                <li class="address__map-item">Пн-Пт: с 8-00 до 20-00</li>
                            </ul>
                            <button class="button address__map-button js-button" type="button">
                                <span>Записаться</span>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/telegram.svg" alt="">
                            </button>
                        </div>
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1077.960643933624!2d36.224644230116894!3d50.01441150213908!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x4127a124791f55cd%3A0x5e53251f4b1136e2!2z0L_RgNC-0YHQvy4g0J3QsNGD0LrQuCwgOUQsINCl0LDRgNGM0LrQvtCyLCDQpdCw0YDRjNC60L7QstGB0LrQsNGPINC-0LHQu9Cw0YHRgtGMLCA2MTAwMA!5e0!3m2!1sru!2sua!4v1559571408119!5m2!1sru!2sua"
                            width="1200" height="587" frameborder="0" style="border:0" allowfullscreen></iframe>
                    </div>
                    <div class="address__map-box js-address__map-box--second js-address__map-box hidden">
                        <div class="address__map-info">
                            <h4 class="address__map-title">Пр. Тракторостроителей, 1 Б</h4>
                            <ul class="address__map-list">
                                <li class="address__map-item"><a href="tel:+380503436040">050-343-60-40</a></li>
                                <li class="address__map-item">Пн-Пт: с 8-00 до 20-00</li>
                                <li class="address__map-item">Сб: с 9-00 до 17-00</li>
                            </ul>
                            <button class="button address__map-button js-button" type="button">
                                <span>Записаться</span>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/telegram.svg" alt="">
                            </button>
                        </div>
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d762.7260331167129!2d36.340796030266674!3d49.98334062354327!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x41270a25d4ace2ff%3A0x726af0adb3253c95!2sXADO!5e0!3m2!1sru!2sua!4v1551876236640"
                            width="1200" height="587" frameborder="0" style="border:0" allowfullscreen></iframe>
                    </div>
                </div>
            </div>
        </section>
        <!--/section map -->

    </main>
    <!--/main -->
<?php
get_footer();
