<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/styles/css/styles.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/styles/css/splide/splide.min.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/styles/css/splide/splide-sea-green-refit.min.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/styles/css/splide/splide-extension-video.min.css">

    <?php wp_head(); ?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-ZXSFKYT6T6"></script>

    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-ZXSFKYT6T6');
    </script>
</head>

<body <?php body_class(); ?>>
<!-- wrapper -->
<div class="wrapper l-container">
    <!-- header -->
    <header class="header">
        <div class="header__inner">
            <h1 class="logo">
                <a href="/">
                    <img class="logo__image" src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.svg"
                         alt="Refit">
                    <span class="logo__text">Реабилитация <br> позвоночника и суставов<br><small style="color: #b51f24">Лицензия МОЗ № 3105/18-М</small></span>
                </a>
            </h1>
            <div class="header__address">
                <div class="header__address-left">
                    <strong><a href="tel:+380503230808">050-323-08-08</a></strong>
                    <span>Пр. Науки, 9 Д</span>
                </div>
                <div class="header__address-right">
                    <strong><a href="tel:+380503436040">050-343-60-40</a></strong>
                    <span>Пр. Тракторостроителей, 1 Б</span>
                </div>
            </div>

            <!-- main nav -->
            <?php if (has_nav_menu('top')) : ?>
                <?php get_template_part('template-parts/navigation/navigation', 'top'); ?>
            <?php endif; ?>
            <!--/main nav -->

            <button class="button header__button js-button" type="button">
                <span>Записаться</span>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/telegram.svg" alt="">
            </button>
            <button class="menu__button hamburger hamburger--squeeze js-menu__button" type="button">
                <span class="hamburger-box">
                    <span class="hamburger-inner"></span>
                </span>
            </button>
        </div>
    </header>


    <!-- main -->
    <main class="main">