<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>
<!-- footer -->
<footer class="footer">
    <div class="footer__inner">
        <strong class="logo footer__logo">
            <a href="/">
                <img class="logo__image" src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.svg" alt="Refit">
                <span class="logo__text">Реабилитация <br> позвоночника и суставов<br><small style="color: #b51f24">Лицензия МОЗ № 3105/18-М</small></span>

            </a>
        </strong>
        <div class="footer__box">
<!--            <small class="footer__copy">Refit.ua все права <br> защищены 2015-2019</small>-->
            <ul class="social-networks">
                <li class="social-networks__item">
                    <a href="#" class="social-networks__link">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/facebook.svg" alt="Youtube Icon">
                    </a>
                </li>
                <li class="social-networks__item">
                    <a href="#" class="social-networks__link">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram.svg" alt="Instagram Icon">
                    </a>
                </li>
                <li class="social-networks__item">
                    <a href="#" class="social-networks__link">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/facebook.svg" alt="Facebook Icon">
                    </a>
                </li>
            </ul>
        </div>
    </div>
</footer>
<!-- /footer -->
<!-- hidden -->
<div class="hidden">
    <div class="form-wrapper">
        <?php echo do_shortcode( '[contact-form-7 id="124" title="Запись на занятие"]' ); ?>
    </div>
</div>
<!--/hidden -->
</div>
<!-- /wrapper -->
<?php wp_footer(); ?>
<script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/lib/jquery/jquery-3.3.1.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/plugins/jquery/jquery.fancybox.pack.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/plugins/splide/splide.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/plugins/splide/splide-extension-video.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/assets/scripts/app.js"></script>
<script type="application/javascript">
  new Splide( '#splide', {
    video: {
      autoplay: true,
      mute: true,
      autoWidth: true,
      autoHeight: true
    }
  } ).mount( window.splide.Extensions );
</script>

</body>
</html>
