var moduleApp = (function (window, $) {
  "use strict";
  // Global Var's
  var $_win = $(window),
    $_html = $('html'),
    $_body = $('body'),

    // Init
    init = function () {
      _events();
    },
    // Bind events
    _events = function () {
      // open fancybox galleries on click
      $(".fancybox").fancybox();
      $(".js-show-video").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        openSpeed: 200,
        closeSpeed: 200,
        maxWidth: 1260,
        fitToView: false,
        width: '70%',
        height: '70%',
        autoSize: false,
        closeClick: false
      });
      function isMobileResolution() {
        var isMobile = false;

        if ($_win.width() <= 480) {
          isMobile = true
        }

        return isMobile;
      }

      function isTabletResolution() {
        var isTablet = false;

        if ($_win.width() <= 768) {
          isTablet = true
        }

        return isTablet;
      }


      /* load youtube video on click */
      function initYoutubePosters() {
        // poster frame click event
        $(document).on('click', '.js-videoPoster', function (ev) {
          ev.preventDefault();
          var $poster = $(this);
          var $wrapper = $poster.closest('.js-videoWrapper');
          videoPlay($wrapper);
        });

        // play the targeted video (and hide the poster frame)
        function videoPlay($wrapper) {
          var $iframe = $wrapper.find('.js-videoIframe');
          var src = $iframe.data('src');
          // hide poster
          $wrapper.addClass('videoWrapperActive');
          // add iframe src in, starting the video
          $iframe.attr('src', src);
        }
      }

      initYoutubePosters();

      /* change address map on click */
      function changeAddressMap() {
        var $addressMapButton = $('.js-tabs-address__button');
        var $addressMapBox = $('.js-address__map-box');

        $addressMapButton.on('click', function (e) {
          var $this = $(this);
          var idx = $this.index();

          e.preventDefault();

          $addressMapButton.removeClass('is-active');
          $addressMapBox.addClass('hidden');
          $this.addClass('is-active');
          $($addressMapBox[idx]).removeClass('hidden');
        });
      }

      changeAddressMap();

      /* init mobile menu */
      function initMobileMenu() {
        var $menuButton = $('.js-menu__button');
        var $nav = $('.js-nav');
        var $headerBox = $('.header__box');

        function toggleMobileMenu() {
          $menuButton.toggleClass('is-active');
          $nav.toggleClass('menu-is-active');
          $headerBox.toggleClass('is-active');
          $_body.toggleClass('is-locked');
        }

        $menuButton.on('click', function (e) {
          e.preventDefault();
          toggleMobileMenu();
        });

        function scrollToSection() {
          var $scrollLink = $('.js-scroll-link, .nav__list a');

          $scrollLink.each(function () {
            var $this = $(this);
            var hash = $this.attr('href');

            $this.on('click', function (e) {
              e.preventDefault();
              if ($nav.hasClass('menu-is-active')) {
                toggleMobileMenu();
              }
              $('html, body').animate({scrollTop: $(hash).offset().top}, 500);
            });
          });
        }

        scrollToSection();
      }

      initMobileMenu();

      /* show more functionality */
      function showMore() {
        var $moreButton = $('.js-more__button');


        $moreButton.on('click', function (e) {
          var $this = $(this);
          var $textBox = $this.closest('.text-box');
          var $moreHolder = $textBox.find('.js-more__holder');
          var $moreBox = $textBox.find('.js-more__box');

          e.preventDefault();
          $moreHolder.addClass('hidden');
          $moreBox.removeClass('hidden');
        })

      }

      showMore();

      /* open form in popup */
      function openForm() {
        var $formWrapper = $('.form-wrapper');
        var $buttonAppointment = $('.js-button');
        $buttonAppointment.on('click', function (e) {
          e.preventDefault();
          $.fancybox($formWrapper);
        });
        /**
         * TODO: make form button colored depending on clicked color
         */
      }

      openForm();


    };
  return {
    init: init
  };
}(window, window.jQuery));
moduleApp.init();


